﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Web.Services;

namespace ProductLookupDemo
{
    public partial class _Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        [WebMethod]
        public static ProductDetail ProductLookup(string productNumber)
        {
            if (string.IsNullOrEmpty(productNumber))
                throw new ArgumentNullException("productNumber");

            return ProductSearch.Lookup(productNumber);
        }

        //Chapter 8 showed this method in Listing 8.10 which is incorrect. The issue in this case is that
        //SearchCriteria is decorated with the DataContract and DataMember attributes which causes an error
        //when the JavaScriptSerializer tries to desearialze the value. If you remember the side note this
        //serializes is different than the DataContractJsonSerializer that is used by WCF. 

        //[WebMethod]
        //public static ProductDetail AdvancedProductLookup(SearchCriteria criteria)
        //{
        //    if (criteria == null)
        //        throw new ArgumentNullException("criteria");

        //    return ProductSearch.Lookup(criteria.ProductNumber);
        //}

 
    }
}
